﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="RozliczenieNadgodzinFiltry.aspx.cs" Inherits="KOLKaP_WEB.KOLKaP.RozliczenieNadgodzinFiltry" %>

<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
  <title>Rozliczenie nadgodzin</title>
  <link href="../Web.css?2" type="text/css" rel="stylesheet" />
    <link rel="stylesheet" href="../jquery/themes/ui-lightness/jquery-ui-1.9.2.custom.min.css" />
    <script src="../jquery/jquery-1.8.3.min.js" type="text/javascript"></script>
    <script src="../jquery/ui/jquery-ui-1.9.2.custom.min.js" type="text/javascript"></script>
    <script src="../jquery/jquery.blockUI.js" type="text/javascript"></script>

  <script type="text/javascript">
    $(function () {

        $("#btnWybierz").button({ icons: { primary: 'ui-icon-print' } });
        $("#btnEksportExcel").button({ icons: { primary: 'ui-icon-calculator' } });
      $("#btnMpzWszystkie").button({ icons: { primary: 'ui-icon-check' } });
      $("#btnMpzOdwroc").button({ icons: { primary: 'ui-icon-transferthick-e-w' } });
      $("#btnStanowiskaWszystkie").button({ icons: { primary: 'ui-icon-check' } });
      $("#btnStanowiskaOdwroc").button({ icons: { primary: 'ui-icon-transferthick-e-w' } });
      $("#btnPracownikWybierz").button();
      $("#btnPracownikUsun").button({ icons: { primary: 'ui-icon-closethick' } });

    });
  </script>
</head>
<body class="Body" style="margin-left: 0; margin-right: 0">
  <form id="form1" runat="server">
    <div>
      <div>
        <asp:Label ID="lblError" runat="server" EnableViewState="False"></asp:Label>
      </div>
      <div style="font-size: 16px; font-weight: bold; margin-bottom: 5px;"><span>Rozliczenie nadgodzin</span></div>
      <div>
        <div style="float: left;">
          <span style="font-size: 12px;">Rok:</span>
          <asp:DropDownList ID="ddlRok" runat="server">
          </asp:DropDownList>
        </div>
        <div style="float: left; margin-left: 10px;">
          <span style="font-size: 12px;">Miesiąc:</span>
          <asp:DropDownList ID="ddlMiesiac" runat="server" Width="110px">
            <asp:ListItem Value="1">Styczeń</asp:ListItem>
            <asp:ListItem Value="2">Luty</asp:ListItem>
            <asp:ListItem Value="3">Marzec</asp:ListItem>
            <asp:ListItem Value="4">Kwiecień</asp:ListItem>
            <asp:ListItem Value="5">Maj</asp:ListItem>
            <asp:ListItem Value="6">Czerwiec</asp:ListItem>
            <asp:ListItem Value="7">Lipiec</asp:ListItem>
            <asp:ListItem Value="8">Sierpień</asp:ListItem>
            <asp:ListItem Value="9">Wrzesień</asp:ListItem>
            <asp:ListItem Value="10">Październik</asp:ListItem>
            <asp:ListItem Value="11">Listopad</asp:ListItem>
            <asp:ListItem Value="12">Grudzień</asp:ListItem>
          </asp:DropDownList>
        </div>
        <div style="float: left; margin-left: 20px;">
          <span style="font-size: 12px;">Pracownik:</span>
          <asp:TextBox ID="tbPracownik" runat="server" ReadOnly="True"></asp:TextBox>
          <asp:Button ID="btnPracownikWybierz" runat="server" Text="..." OnClick="btnPracownikWybierz_Click" ></asp:Button>
          <asp:Button ID="btnPracownikUsun" runat="server" OnClick="btnPracownikUsun_Click" Text="x" ></asp:Button>
        </div>
        <div style="float: right;">
          <asp:LinkButton ID="btnWybierz" runat="server" Text="Podgląd wydruku" CssClass="aspButton" OnClick="btnWybierz_Click"></asp:LinkButton>
          <asp:LinkButton ID="btnEksportExcel" runat="server" Text="Eksport do excel" CssClass="aspButton" OnClick="btnEksportExcel_Click"></asp:LinkButton>
        </div>
      </div>
      <div style="clear: both;">
        <div style="float: left;">
          <div>
            <asp:CheckBox ID="cbAktywne" runat="server" Text="Aktywne" CssClass="aspCheckbox"
              AutoPostBack="True" Checked="True"></asp:CheckBox>
            <asp:LinkButton ID="btnMpzWszystkie" runat="server" Width="110px" Text="Wszystkie"
              CssClass="aspButton" OnClick="btnMpzWszystkie_Click"></asp:LinkButton>
            <asp:LinkButton ID="btnMpzOdwroc" runat="server" Width="110px" Text="Odwróć" CssClass="aspButton" OnClick="btnMpzOdwroc_Click"> </asp:LinkButton>
          </div>
          <div>
            <asp:GridView ID="gvJednostki" runat="server" AutoGenerateColumns="False" DataKeyNames="ID_MPZ" Width="100%" CssClass="aspGrid" DataSourceID="sdsJednostki" DataMember="DefaultView" AllowSorting="True">
              <Columns>
                <asp:TemplateField>
                  <EditItemTemplate>
                    <asp:CheckBox ID="CheckBox1" runat="server" Checked='<%# Wybrana((System.Data.DataRowView)Container.DataItem) %>' />
                  </EditItemTemplate>
                  <ItemTemplate>
                    <asp:CheckBox ID="cbZaznacz" runat="server" Checked='<%# Wybrana((System.Data.DataRowView)Container.DataItem) %>' />
                  </ItemTemplate>
                  <ItemStyle Width="40px" />
                </asp:TemplateField>
                <asp:BoundField DataField="NAZWA" HeaderText="Jednostka" ReadOnly="True" SortExpression="NAZWA" />
              </Columns>
              <RowStyle CssClass="TableItem" />
              <HeaderStyle CssClass="TableHeader" />
              <AlternatingRowStyle CssClass="TableItemAlt" />
            </asp:GridView>
            <asp:SqlDataSource ID="sdsJednostki" runat="server" SelectCommand="dbo.MPZ_LIST" SelectCommandType="StoredProcedure" OnSelected="sdsJednostki_Selected">
              <SelectParameters>
                <asp:SessionParameter Name="P_ID_FIRMY" SessionField="ID_FIRMY" />
                <asp:ControlParameter Name="P_AKTYWNE" ControlID="__Page" PropertyName="AktywneJednostki" Size="1" Type="Char" />
              </SelectParameters>
            </asp:SqlDataSource>
          </div>
        </div>
        <div style="float: left;">
          <div>
            <asp:CheckBox ID="cbStanowiskaAktywne" runat="server" Text="Aktywne" CssClass="aspCheckbox"
              AutoPostBack="True" Checked="True"></asp:CheckBox>
            <asp:LinkButton ID="btnStanowiskaWszystkie" runat="server" Width="110px" Text="Wszystkie"
              CssClass="aspButton" OnClick="btnStanowiskaWszystkie_Click"></asp:LinkButton>
            <asp:LinkButton ID="btnStanowiskaOdwroc" runat="server" Width="110px" Text="Odwróć" CssClass="aspButton" OnClick="btnStanowiskaOdwroc_Click"> </asp:LinkButton>
          </div>
          <div>
            <asp:GridView ID="gvStanowiska" runat="server" AutoGenerateColumns="False" DataKeyNames="ID_STANOWISKA" Width="100%" CssClass="aspGrid" DataSourceID="sdsStanowiska" DataMember="DefaultView" AllowSorting="True">
              <Columns>
                <asp:TemplateField>
                  <EditItemTemplate>
                    <asp:CheckBox ID="CheckBox1" runat="server" Checked='<%# Wybrana((System.Data.DataRowView)Container.DataItem) %>' />
                  </EditItemTemplate>
                  <ItemTemplate>
                    <asp:CheckBox ID="cbZaznacz" runat="server" Checked='<%# Wybrana((System.Data.DataRowView)Container.DataItem) %>' />
                  </ItemTemplate>
                  <ItemStyle Width="40px" />
                </asp:TemplateField>
                <asp:BoundField DataField="NAZWA" HeaderText="Stanowisko" ReadOnly="True" SortExpression="NAZWA" />
              </Columns>
              <RowStyle CssClass="TableItem" />
              <HeaderStyle CssClass="TableHeader" />
              <AlternatingRowStyle CssClass="TableItemAlt" />
            </asp:GridView>
            <asp:SqlDataSource ID="sdsStanowiska" runat="server" SelectCommand="dbo.S_STANOWISK_LIST" SelectCommandType="StoredProcedure" OnSelected="sdsStanowiska_Selected">
              <SelectParameters>
                <asp:SessionParameter Name="P_ID_FIRMY" SessionField="ID_FIRMY" />
                <asp:ControlParameter Name="P_AKTYWNE" ControlID="__Page" PropertyName="AktywneStanowiska" />
              </SelectParameters>
            </asp:SqlDataSource>
          </div>
        </div>
      </div>
    </div>
  </form>
</body>
</html>
